#ifndef	_MUSICOLOUR_H
#define _MUSICOLOUR_H

// THIS IS a FINAL RELEASE VERSION
// Revision Number 2.10
#define VERSION 1.60
// Release Version...
//*****************************************************************************
//*****************************************************************************
//* Important Constants and Defines
//*****************************************************************************
//*****************************************************************************
//  Define EXTERNAL_XTAL=1 if using an external 7.3728MHz crystal 
//  and 0 if not (ie using the internal Fast RC 7.37MHz osc instead)
//*****************************************************************************
//
//*****************************************************************************
//
//*****************************************************************************
//
//*****************************************************************************
#define DEBUG 				0
#define USE_EXTENDED_MODE	1				// set to 1 if you are having run time errors with Stack Overflows
#define USE_DIMMING_CURVE 	1
#define DOUBLE 				float
//#define EXTERNAL_XTAL		0
#define REMOTE_CONTROL 		1
#define STARTUP_TIME_DELAY	600				// for safety.
#define BLINK_TIME			1
#define BLINK_TIME_LONG		2
#define INCLUDE_FAST_SOFTWARE_UPGRADE	0	// not currently used.

#define READING_INDEX			64
#define WRITING_INDEX			(READING_INDEX+128)
#define SECURE_UART_TIMEOUT		30000
#define WRITING_VAL				1
#define READING_VAL				2
#define SECURE_VERSION_MAJOR	0x01
#define SECURE_VERSION_MINOR	0x00
#define HEX_PROTECT_BASE		0x7600		// this must match the linker script!
#define UPPER_CRC_LIMIT			(HEX_PROTECT_BASE)
#define HEX_PROTECT_TOP			0x8000
#define RESET_SECONDS			9
#define CANCEL_TRIES			3
#define UART_BUFFER_SIZE		16
#define WRITE_PROTECTION_OFF	1
#define WRITE_ECHO_ON			2
#define WRITE_ECHO_CRC			4

#if (EXTERNAL_XTAL==1)
	#define FCY 			29491200.0		// Instruction clock frequency (MIPS)
	#define FCY100H			0x002D
	#define DELAY_64US		1887
	#define DELAY_100MS		0x2D00
	#define DELAY_STRING	asm("repeat #14735\n nop")			// should be roughly FCY/2000-10
#else
	#define FCY				29480000.0		// Instruction clock frequency (MIPS) when running off internal fast RC (7.37MHz) with 16PLL
	#define FCY100H			0x002D
	#define DELAY_64US		1886
	#define DELAY_100MS		0x2D00
	#define DELAY_STRING 	asm("repeat #14730\n nop")			// should be roughly FCY/2000-10
#endif

#define TUNING_STRING    asm("repeat #9998\n nop")		// used for fine tuning!
#define FOUR_NOPS		 asm("nop\n nop\n nop\n nop")
//*****************************************************************************
#define SPLASH_STRING 		"Musicolour ver:"
#define FAST_SPLASH_STRING 	"ver:"
#define YEAR_STRING			"(2008)   "
#define NUM_DIGITS 8	// number of decimal digits processed by the printITOA function (5= 16 bit unsigned int) must be at least 2 because buffer is used in printTitle function
#if (NUM_DIGITS<2)
	#define NUM_DIGITS	2
#endif

#define OUTPUT_RATE_DEFAULT				1000
#define OUTPUT_FREQ_MIN					1
#define OUTPUT_FREQ_MAX					50
#define OUTPUT_RATE_FREQ				15625.0			// this is 1/64us: sampling frequency for RC5 remote control decoding...
#define SetOutputTimeOut()				outputTimer=outputRate;
#define BLANK_TIMEOUT					1
#define MESSAGE_TIMEOUT					200				// 2 seconds
#define MAINS_AVERAGING_COUNT			4
#define QUIESCENT_DIVISOR_LOG2			2	
#define ADC_DENOMINATOR 				1023
#define ADC_LOG2						10			// bit resolution of the ADC conversion
#define	FIXED_DENOMINATOR				1023		// should be a power of 2
#define FIXED_DENOMINATOR_LOG2			10			
#define FIXED_DENOMINATOR_LOG2_AND1		11			// this is log2(FIXED_DENOMINATOR)+1
#define LEVEL_LOG2						8
#define MAX_BIN_LOG2					8
#define MAX_BIN							255
#define LEVELS_MAX						255
#define LEVELS_LOG2						8
#define CLIP_MAX						0x4000		// 3.75V = 0x4000 ie. 65536*(3.75V-2.5V/5V)
#define CLIP_MIN						0x4CCC		// 1.0V  = 0x4CCC ie. 65536*(2.5V-1.0V/5V)
// adcStatus can be:
#define SILENT4							0x0020
#define SILENT3							0x0010
#define SILENT2							0x0008
#define SILENT1							0x0004
#define SILENCE							(SILENT1 | SILENT2 | SILENT3 | SILENT4 )
#define SILENCE_TIMEOUT					5			// in 100ms
//
#define SILENCE_THRESHOLD_DEFAULT		10
#define SILENCE_THRESHOLD_LOG2			8
#define ZV_THRESHOLD_LOG2				12
//
#define CLIP_R							0x0002
#define CLIP_L							0x0001
#define NO_STATUS						0
//*****************************************************************************
//*****************************************************************************
//  Define the pinouts for controlling the Dot Matrix LED display (must be in PORTE)
#define INTCOUNTDOWN_TIMER_INITIAL		0		// in 100ms
#define CHASER_TIMEOUT_INITIAL			-1
#define GBIT 	RE2
#define CK1BIT 	RE3
#define CK2BIT 	RE1
#define SERBIT 	RE0
//*****************************************************************************
// Other Constants
//*****************************************************************************
//  The following define the ADC channels corresponding to logical channels
// 	The pot channel is AN0
#define CHANNELMIC 			0		// channel for mic input (AN1)
#define CHANNELL			1		// channel for left audio input (AN2)
#define CHANNELR			2		// channel for right audio input (AN3)
#define INPUT_CHANNELS	 	3
#define DEFAULT_INPUT_CHANNEL 	(CHANNELMIC)
//
#define GAIN_SCALE			8.0
#define MIC_GAIN			5.0
#define LEFT_GAIN			2.0
#define RIGHT_GAIN			2.0
#define RIGHT_GAIN_MIN		(0.0*GAIN_SCALE)
#define RIGHT_GAIN_MAX		(10.0*GAIN_SCALE)
#define LEFT_GAIN_MIN		(0.0*GAIN_SCALE)
#define LEFT_GAIN_MAX		(10.0*GAIN_SCALE)
#define MIC_GAIN_MIN		(0.0*GAIN_SCALE)
#define MIC_GAIN_MAX		(30.0*GAIN_SCALE)		// must not be greater than 255
//*****************************************************************************
// Behaviour of RF6 output pin
//*****************************************************************************
//  The following define the modes for RF6 output
#define INPUT_REMOTE 		0		// for REMOTE CONTROL input
#define SCREEN_REFRESH 		1		// LED indicates Screen Refresh frequency
#define MAINS_SYNC 			2		// LED indicates Mains Sync
#define ADC_ACQUIRE 		3		// LED indicates ADC acquire
#define OC1_TRIGGER			4		// Channel 1 trigger
//#define OC2_TRIGGER		5		// Channel 2 trigger
//#define OC3_TRIGGER		6		// Channel 3 trigger
//#define OC4_TRIGGER		7		// Channel 4 trigger
#define PERIODS 			5		// total number of modes
#define OUTPUT_BAUD16		5		// for IrDA endec if enabled...
#define OUTPUT_SYSTEM_CLK	6		// for measuring the internal system clock
#define	RF6MODULUS			7
#define DEFAULT_RF6MODE		(INPUT_REMOTE)	// current setting
#define TRIACS				(OC1_TRIGGER)
//*****************************************************************************
// Behaviour Constants
//*****************************************************************************
//  The following define the modes for main software loop
//
#define MODE_AUTO 				0
#define MODE_USER				1
#define MODE_MENU 				3
//
#define MODE_BIT_SHIFT			0
#define MODE_CLEAR				0x0003
//
#define MODE_CHASER_OFF			0
#define MODE_CHASER_AUTO		1
#define MODE_CHASER_NORMAL		2
#define MODE_CHASER_TRIGGERED	3
//
#define MODE_CHASER_BIT_SHIFT	2
#define MODE_CHASER_CLEAR		0x0003
#define MODE_DEFAULT 			0
//
#define MODE_FAST_BOOT			0x0010
#define MODE_REMOTE_CONTROL		0x0020
//
// mainMode is currently as follows
// Bit 15	14	13	12	11	10	9	8	7	6	5	4	3	2	1	0
//													FB	Ch Ch   Mm  Mm
// Mm=main mode either: MODE_AUTO MODE_USER or MODE_MENU
// Ch=chaser mode either OFF AUTO NORMAL TRIGGERED
// FB= Fast boot  1=disable all messages 0= normal boot
// 
#define CHASER_PROGRAM_DEFAULT	0
//*****************************************************************************
// Behaviour Constants
//*****************************************************************************
// Mappings for the LEDs on the display board
#define ERROR_LED 	PORTEbits.RE4
#define FCY_LED 	PORTFbits.RF6
#define LED1 		0x0008
#define LED2 		0x0010
#define LED3 		0x0040
#define LED4 		0x0002
#define LED5 		0x0004
#define LED6 		0x0001
#define LED7 		0x0020
#define CHANNEL_LEDS	(LED4 | LED5 | LED6 | LED7 )
#define LEDS		display[DISPLAY_COLUMNS]
#define FLASHING	flashing
#define FLASH_OFF	0xFF00
#define FLASH_ON	0x0000
#define DISPLAY_OFF	0x0000
#define NOKEY 		0xFFFF
#define KEY1 		0x0001
#define KEY2 		0x0000				// careful KEY2 and KEY1 are "swapped" in terms of their natural value!
#define KEY3 		0x0002
#define KEY4 		0x0003
#define KEY5 		0x0004
#define KEY6 		0x0005
#define KEY7 		0x0006
#define KEYUP 		0x0007
#define KEYDOWN 	0x0008
#define MAXKEY 		0x0006
#define MINKEY 		0x0000
#define IRKEYS						9
#define DIGITAL_POT_DELTA			24
#define ADAPTIVE_POT_THRESHOLD 		24
#define POT_MIN_VALUE				0x0010
#define POT_MAX_VALUE				0x03F0
#define MOVEMENT_POT_THRESHOLD		260			// if pot value moves more than then consider it having moved.
#define AVG_POT_TIMES				150			// number of averages for pot
#define SCREEN_SAVER_DEFAULT		2
//*****************************************************************************
// Interrupt Priorities 0-7 (0=lowest 7=highest) priority
//*****************************************************************************
// priority 0 is the lowest while 7 is the highest
#define T1IPRI 		0x0000		// for T1 (this interrupt is actually not currently enabled)
#define OC1IPRI 	0x0003		// for OC1
#define OC2IPRI 	0x0003		// for OC2
#define OC3IPRI 	0x0003		// for OC3
#define OC4IPRI 	0x0003		// for OC4
#define LVDIPRI		0x0003		// for LVD module
#define T4IPRI		0x0004		// for T4
#define T5IPRI		0x0004		// for T5
#define CNIPRI 		0x0005		// for key presses
#define ADCIPRI 	0x0004		// for ADC interrupt
#define T3IPRI 		0x0005		// for screen refresh (timer 3)
#define INT0IPRI	0x0006		// for INT0 Interrupt
#define	T2IPRI		0x0007		// for T2 (output compare) should be highest and higher than INT0 sync correction
//*****************************************************************************
// Behaviour Constants
//*****************************************************************************
// Mappings for the LEDs on the display board
// default values for phase control
#define OUTPUTENABLE_ALLON		0xFF
#define OUTPUTENABLE_ALLOFF 	0x00
#define PHASE0_MASK 			0x000F
#define PHASE1_MASK 			0x00F0
#define DISABLE_NESTED 			1			// used to disable (=1) or enable (=0) nested interrupts
//*****************************************************************************
#define PHASES					2			// number of phases
#define T2PERIOD_DEFAULT 		6000.0		// can be a bit higher than normal max phase offset which is around 4606 for 50Hz
#define ZV_OFF					(T2PERIOD_DEFAULT+1)
#define ZV_ON					100
#define ZV_THRESHOLD_DEFAULT	3000		// around 80% for 50Hz mains
#define PHASE_OFFSET0		850.0			// some good initial values- based on empirical measurements 850
#define PHASE_OFFSET1 		150.0			// some good initial values- based on empirical measurements 150
#define PHASE0_CALOFFSET	280.0
#define PHASE1_CALOFFSET	280.0
#define PHASE0_MIN			0.0
#define PHASE0_MAX			1000.0
#define PHASE1_MIN			0.0
#define PHASE1_MAX			1000.0
#define SYNCSTARTUPDELAY 	1000.0		// in ms
#define PULSE_WIDTH 		64.0		// pulse width period = (PULSE_WIDTH * T2PRESCALE / fcy ) so 80= around 175us.
#define PULSE_ERROR0 		200.0		// should be at least greater than pulse width
#define PULSE_ERROR1		200.0		// should be at least greater than pulse width
#define PHASE_STROBE		(ZV_ON)		// used for fully on triacs when in strobe mode same as zero voltage switching mode
#define T1PRESCALE			64.0		// prescaler for Timer 1 (with 64x prescaler and running at 30Mhz we can measure frequencies from 7 Hz to about 400kHz.
#define T2PRESCALE			64.0		// prescaler for Timer 2
#define T3PRESCALE			256.0		// prescaler for Timer 3 (used for screen refresh)

#if (REMOTE_CONTROL==0)
	#define T45PRESCALE		1.0			// prescaler for 32 bit Timer T4/5
#else
	#define T4PRESCALE		1.0
	#define T5PRESCALE		256.0
#endif
#define T45TIME_PRESCALE	256.0
#define MAINS_50					50.0
#define MAINS_60					60.0
#define MAINSFREQ_DEFAULT 			(MAINS_60)  		// in Hz, the default if no good mains freq is detected automatically (higher is safer more fool proof)
#define MAINS_MIN 					45.0				// in Hz, lowest considered mains freq for auto detect
#define MAINS_MAX 					65.0				// in Hz, highest considered mains freq for auto detect
#define MAINS_THRESHOLD 			55.0				// in Hz, below which the frequency will be set to 50Hz above which it will be set to 60 Hz.
#define CORRECT_FACTOR_MIN			0.95				// within 5%
#define CORRECT_FACTOR_MAX  		1.05				// within 5%
#define MAINS_DETECT_TRIES 			20					// number of times to try for auto detection till fail
#define MAINS_DETECT_PAUSE 			250					// pause between detect tries (in ms)
#define WAIT_FOR_UPDATED_TIMEOUT	100					// in 100ms
#define MAX_AUDIO_FREQ 				22000.0				// the maximum audio frequency in Hz
#define TADS						4
#define ADC_SAMPLING_FREQ			22000.0				// this constant is found in the file fft.h
#define ADC_SAMPLING_FREQ_MIN		16000.0				// the minimum allowed (there will be aliasing above half this frequency
#define ADC_SAMPLING_FREQ_MAX		50000.0				// the maximum allowed
#define DISPLAY_COLUMNS 			15					// total number of columns of LED display (must be at least 15!)
#define DISPLAY_ROWS 				7					// total number of rows of LED display
#define OUTPUT_CHANNELS 			4					// total number of TRIAC output channels (phase control)
#define KEY_BUFFER_SIZE 			16					// FIFO buffer size for key queue
#define NUM_KEYS 					7					// total number of key inputs
#define NUM_KEY_TRANSITIONS			3
#define KEY_REPEAT_DELAYMS			200
#define KEY_WAIT_DELAY				500
#define STATE_KEY1_INDEX			2
#define STATE_KEY2_INDEX			1
#define STATE_KEY3_INDEX			0
#define KEY_HOLD_TIME 				4					// for debouncing the keys (100ms)
#define FREQ_DELAY 					0x0078				// for measuring frequency- should be a multiple of 4
#define SCREEN_FREQ_DEFAULT			180					// 0-255 gives range from MIN to MAX 
#define SCREEN_FREQ_MIN				50.0				// in Hz (the minimum allowable screen refresh frequency)
#define SCREEN_FREQ_MAX				120.0				// in Hz (the maximum allowable screen refresh frequency)
#define LED_ON_PERIOD				50					// applies to the LED on period (constant)
#define SCREEN_ON_MIN				10
#define	SCREEN_OFF_MIN				1
#define SCREEN_BRIGHTNESS			0x00F0				// default for screen brightness
#define CH1	0
#define CH2	1
#define CH3	2
#define CH4	3
#define DEFAULT_OUTPUT_CHANNEL 	CH1
#define CH1_MINFREQ_DEFAULT		0
#define CH1_MAXFREQ_DEFAULT		600
#define CH2_MINFREQ_DEFAULT		600
#define CH2_MAXFREQ_DEFAULT		1200
#define CH3_MINFREQ_DEFAULT		1200
#define CH3_MAXFREQ_DEFAULT		2400
#define CH4_MINFREQ_DEFAULT		2400
#define CH4_MAXFREQ_DEFAULT		22000
//
#define TEST_OUTPUTS_DELAY_MS		10					
#define TEST_OUTPUTS_DELAY_MS_LONG	500
#define AUTO_DIM_DELAY				10					// for automatic dimmer in stateDimmer
// Screen Savers
#define SCREEN_SAVERS			5					// total number of screen savers implemented
// Modes For Each Channel	
// ch[xx].mode= an integer such that 
// ZV_MODE=1 (Zero Voltage Switching Mode) then the output channel is either ON or OFF according to the zvThreshold, ZV_ON, and ZV_OFF 
//        =0 then normal brightness and phase controlled output
// DIRECT_MODE=1 or STROBE_MODE=0 then the setOutputLevel function affects the value of the output channel directly
// STROBE_MODE=1 then in stroboscope mode
// CONTINUOUS_MODE=1 then setOutputLevel chases according to attack and decay values for the channel
// EQUALIZER_MODE=1 then equalizer settings affect the channel output
// FFT_MODE=1 then setbinlevels
// AVG_MODE=1 then average out bin levels for the channel
// AVG_MODE=0 then use peak accumulation (PEAK_MODE)
#define ZV_MODE				0b0000000000000001			// on for Zero voltage switching off= brightness mode
//
#define STROBE_MODE			0b0000000000000010			// on for strobe off for direct mode
#define CONTINUOUS_MODE		0b0000000000000100			// continuous mode
#define DIRECT_MODE			0b0000000000001000
//
#define EQUALIZER_MODE		0b0000000000010000
//
#define CHASER_MODE			0b0000000000100000
#define FFT_MODE			0b0000000001000000
//
//#define CHASER_TRIG_MODE	0b0000000010000000
#define AUTO_MODE			0b0000000100000000
//
#define AVG_MODE			0b0000001000000000
//#define PEAK_MODE			0b0000010000000000
//
#define TOTAL_MODES			4
//
//
#define CHASER_MODE_OFF			0
#define CHASER_MODE_AUTO		1
#define CHASER_MODE_NORMAL		2
#define CHASER_MODE_TRIGGERED	3
//
// modes for SetOutputLevel function
#define NORMAL_MODE			0		// do update LEDS with output levels
//#define CHASER_MODE		1		// coming from chaser
//#define FFT_MODE			2		// coming from FFT
#define NO_UPDATE_MODE		3		// do not update LEDS with output levels
#define DEFAULT_CH_MODE 		(DIRECT_MODE)
#define DEFAULT_CH_MODE_INDEX	1
//
// doFFT function modes
#define DOFFT					0x0000
#define DOFFT_UPDATE_PEAK		0x0001
// drawChannels function modes
#define DRAWCHANNELS			0x0000
#define DRAWCHANNELS_QUIESCENT	0x0001
#define DRAWCHANNELS_ENVELOPE	0x0002
//
#define AVG_THRESHOLD					8
#define CONT_POS_THRESHOLD				10
#define CONT_NEG_THRESHOLD				0
//
#define LED_ON_TIMEOUT					1
#define LED_OFF_TIMEOUT					6
#define SCREEN_ON_TIMEOUT				9
#define SCREEN_OFF_TIMEOUT				1
#define MEMORIES 						4
#define HALFKB_DIVIDED_BY_MEMORIES		96			// aligned to 32

// Boot Detection
#define MAGIC_EEPROM_ADDRESS			480 		// aligned to 32
// Note: MAGIC_EEPROM_ADDRESS=((MEMORIES+1)*HALFKB_DIVIDED_BY_MEMORIES) this is the address of SYSTEM magic word
//  and you will get Address Errors if this address is greater than 512 - 32 = 480.
#define MAGIC_CALIBRATION_ADDRESS		481			// you will get errors if this is greater than 480+1
#define MAGIC_CRC_ADDRESS				482			// TO STORE the CRC
#define VIEWMODE_ADDRESS				483
#define TUN_ADDRESS						484
#define INTEGRITY_ADDRESS				485
#define FCY_ADDRESS						486
#define REMOTE_CONTROL_DEFS_ADDRESS		488			// this is the start address for storing the remote control codes (10 words)
//
#define MAGIC_REMOTE_CONTROL_VALUE		0x0043		// a magic value to say the remote control codes have been defined...
//
#define MAGIC_VALUE						0x005A		// this can be any byte (except not 00 or FF) used to detect POR (power on reset) and First Time boot.
#define MAGIC_CALIBRATION_VALUE			0x0018		// as above
#define SAVED_EEPROM_ADDRESS			15			// equal to the actual EEPROM address where variable saved gets saved by PutAllSettings
//
#define NO_BOOT							0
#define FIRST_BOOT						1
#define POR_BOOT						2
#define NO_CALIBRATION					4
//
#define INTP						1
#define UINTP						2
#define DOUBLEP						3
//*****************************************************************************
// Other Constants
//*****************************************************************************
#define UART_TIMEOUT				5			
#define UART_TX_OVERRUN			0xFFFF
#define UART_TX_TIMEOUT			0xFFFE
#define UART_RX_OVERRUN			0xFFFD
#define UART_RX_TIMEOUT			0xFFFC
#define UART_RX_EMPTY			0xFFFB
#define UART_ERROR				0xFFFA
#define UART_OK					0x0000
#define ESCAPE_CHAR				0x1B
#define UART_IRDA				0x1000
#define UART_BAUD_MODULO		6143			// gives 300 as the lowest baud rate
#define UART_FREQ16				1843200.0
#define UART_DEFAULT_BAUDRATE	191				// gives 9.6 Kbps
//
#define TRUE 					1
#define FALSE 					0
#define HALF_INT 				32768L
#define FULL_INT 				65536L
#define FULL_BYTE				256
//#define FULL_LONG				4294967296.0
//#define HALF_LONG				2147483648.0
// modes for printchar function
#define CHAR_BLANKING			0x80
#define	TO_SCREEN				0
#define TO_FLASHING				1
#define TO_UART					2
//
#define TOTAL_DIGITS_SMALL		4				
#define TOTAL_DIGITS_BIG		5
#define SMALL_FONT				1
#define BIG_FONT				0
//*****************************************************************************
// Constant that affect the screen savers
//*****************************************************************************
#define RMS_SCALING_FACTOR_LOG2 	9			// approximate factor to divide by FFT data to compute RMS...
#define VUANALOG_FACTOR 			1.0
#define OSC_FACTOR 					10.0		// was 40.0
//*****************************************************************************
// Constant that affect delays
//*****************************************************************************
#define SCROLL_DELAY 			22		// delay between scrolling columns (ms)
#define DELAY_IF_KEY_PRESSED	16		// in ms
#define UPDOWN_DELAY 			30		// delay for up down scrolling (ms)
#define SCREEN_TIMEOUT_DEFAULT	3000.0	// in 100ms units	=5 minutes
#define SCREEN_TIMEOUT_INITIAL	10000.0	// long enough to allow start up in 100ms units
#define PRINT_TITLE_TIMEOUT 	25		// 2.5s
#define REDRAW_TIMEOUT			1
//	 
#define SNOW_TIMEOUT 			2		 
#define LIFE_TIMEOUT 			3		 
#define LIFE_TOTAL_TIMES 		70
#define LIFE_SEED 				50
#define LIFE_DELAY 				400
//
#define ML_SPEC_FINE			0
#define ML_CHN_AVG				1
#define ML_SPEC_CENTRE			2
#define ML_CHN_SINGLE			3
#define ML_SPEC_WIDE			4
#define ML_SCROLL_RMS			5
#define ML_ANALOG_VU			6
#define ML_LAST					7
#define ML_TOTAL				8
//
#define ML_SPEC_FINE_TIMEOUT	1
#define ML_CHN_AVG_TIMEOUT		1
#define ML_SPEC_CENTRE_TIMEOUT	1
#define ML_CHN_SINGLE_TIMEOUT	1
#define ML_SPEC_WIDE_TIMEOUT	1
#define ML_SCROLL_RMS_TIMEOUT	1
#define ML_ANALOG_VU_TIMEOUT	1
//*****************************************************************************
// Constant that affect the Finite State Machine
//*****************************************************************************
// States for Finite State Machine
//
// Main Menu States
#define CHANNEL_MENU_STATE					2
#define TRIGGER_MENU_STATE					3
#define CONSOLE_MENU_STATE					4
#define OUTPUT_MENU_STATE					5
#define AUDIO_MENU_STATE					6
#define SYSTEM_MENU_STATE					7
#define DISPLAY_MENU_STATE					8
#define DEFAULTS_MENU_STATE					9
#define ADVANCED_MENU_STATE					10
#define INFORMATION_MENU_STATE				11
#define RESERVED_MENU_STATE					12
//
// Sub Menu States
//
// Display Sub Menus
#define SETDISPLAY_BRIGHTNESS_MENU_STATE	21
#define SETDISPLAY_BRIGHTNESS_STATE			22
#define	SETDISPLAY_FREQUENCY_MENU_STATE		23
#define	SETDISPLAY_FREQUENCY_STATE			24
#define	SETDISPLAY_TIMEOUT_MENU_STATE		25
#define	SETDISPLAY_TIMEOUT_STATE			26
#define SETDISPLAY_SCREENSAVER_MENU_STATE	27
#define SETDISPLAY_SCREENSAVER_STATE		28
#define SETDISPLAY_DEFAULTS_MENU_STATE		29
#define SETDISPLAY_DEFAULTS_STATE			30
//
// Information Sub Menus
#define SEE_ADC_FREQ_STATE					35
#define SEE_MAINS_FREQ_STATE				36
#define SEE_SCREEN_FREQ_STATE				37
#define SEE_OC_TRIGGER_FREQ_STATE			38
#define SEE_ADC_DUTY_STATE					39
#define SEE_MAINS_DUTY_STATE				40
#define SEE_SCREEN_DUTY_STATE				41
#define	SEE_OC_TRIGGER_DUTY_STATE			42
#define SEE_FCY_STATE						43
#define SEE_ACCURACY_STATE					44
#define SEE_DETECTED_STATE					45
#define SEE_CRC_STATE						46
//
// Trigger Sub Menus
#define SETTRIGGER_MINFREQ_MENU_STATE		50
#define SETTRIGGER_MAXFREQ_MENU_STATE		51
#define	SETTRIGGER_THRESHOLD_MENU_STATE		52
#define SETTRIGGER_MINFREQ_STATE			53
#define SETTRIGGER_MAXFREQ_STATE			54
#define	SETTRIGGER_THRESHOLD_STATE			55
#define SETTRIGGER_DEFAULTS_MENU_STATE		56
#define SETTRIGGER_DEFAULTS_STATE			57
//
// Advanced Sub Menus
#define CALIBRATE_MENU_STATE				60
#define CALIBRATE_STATE						61
#define SOFTWARE_UPGRADE_MENU_STATE			62
#define SOFTWARE_UPGRADE_STATE				63
#define PEEK_MENU_STATE						64
#define PEEK_STATE							65
#define TUNING_MENU_STATE					66
#define TUNING_STATE						67
#define WRITE_MODE_MENU_STATE				68
#define WRITE_MODE_STATE					69
//
// System Sub Menus
#define SEE_SOFTWARE_VERSION_STATE			80
#define SETRS232_MENU_STATE					81
#define SETRS232_STATE						82
#define SETREMOTE_MENU_STATE				83
#define SETREMOTE_STATE						84
#define SETIRDA_MENU_STATE					85
#define SETIRDA_STATE						86
#define TESTOUTPUTS_MENU_STATE				87
#define TESTOUTPUTS_STATE					88
#define DIAGNOSTICS_MENU_STATE				89
#define DIAGNOSTICS_STATE					90
#define SEE_DETECTED_MAINS_FREQ_STATE		91
#define STARTUP_MODE_MENU_STATE				92
#define STARTUP_MODE_STATE					93
#define RESET_MENU_STATE					94
#define RESET_STATE							95
#define RF6_MENU_STATE						96
#define RF6_STATE							97
#define SETSYSTEM_DEFAULTS_MENU_STATE		98
#define SETSYSTEM_DEFAULTS_STATE			99
#define DEFINE_REMOTE_MENU_STATE			100
#define DEFINE_REMOTE_STATE					101
//
// The Output Sub Menus
#define HIGH_CONTRAST_MENU_STATE			104
#define HIGH_CONTRAST_STATE					105
#define PERMUTE_MENU_STATE					106
#define PERMUTE_STATE						107
#define CHASER_MODE_MENU_STATE				108
#define CHASER_MODE_STATE					109
#define CHASER_PROGRAM_MENU_STATE			110
#define CHASER_PROGRAM_STATE				111
#define QUIESCENT_MENU_STATE				112
#define QUIESCENT_STATE						113
#define RATE_MENU_STATE						114
#define RATE_STATE							115
#define SILENCE_MENU_STATE					116
#define SILENCE_STATE						117
#define SETOUTPUTS_DEFAULTS_MENU_STATE		118
#define SETOUTPUTS_DEFAULTS_STATE			119
// The Audio Sub Menus
#define EQUALIZER_MENU_STATE				120
#define EQUALIZER_STATE						121
#define INPUT_BALANCE_MENU_STATE			122
#define INPUT_BALANCE_STATE					123
#define SETADC_FREQ_MENU_STATE				124
#define SETADC_FREQ_STATE					125
#define SETAUDIO_DEFAULTS_MENU_STATE		126
#define SETAUDIO_DEFAULTS_STATE				127
#define OUTPUT_ENABLE_MENU_STATE			128
#define OUTPUT_ENABLE_STATE					129
// The Channel Sub Menus
#define CHANNEL_MINFREQ_MENU_STATE			130
#define CHANNEL_MAXFREQ_MENU_STATE			131
#define CHANNEL_MINFREQ_STATE				132
#define CHANNEL_MAXFREQ_STATE				133
#define CHANNEL_GAIN_MENU_STATE				134
#define CHANNEL_GAIN_STATE					135
#define CHANNEL_MODE_MENU_STATE				136
#define CHANNEL_MODE_STATE					137
#define CHANNEL_ATTACK_MENU_STATE			138
#define CHANNEL_ATTACK_STATE				139
#define CHANNEL_DECAY_MENU_STATE			140
#define CHANNEL_DECAY_STATE					141
#define CHANNEL_TEST_MENU_STATE				142
#define CHANNEL_TEST_STATE					143
#define CHANNEL_FREQ_MENU_STATE				144
#define CHANNEL_FREQ_STATE					145
#define SETCHANNEL_DEFAULTS_MENU_STATE		146
#define SETCHANNEL_DEFAULTS_STATE			147
// The Defaults Sub Menus
#define LOAD_DEFAULTS_MENU_STATE			150
#define LOAD_DEFAULTS_STATE					151
#define SAVE_SETTINGS_MENU_STATE			152
#define SAVE_SETTINGS_STATE					153
#define RECALL_SETTINGS_MENU_STATE			154
#define RECALL_SETTINGS_STATE				155
#define AUTO_SAVE_MENU_STATE				156
#define AUTO_SAVE_STATE						157
//
// The Console Sub Menus
#define COM_MENU_STATE						170
#define COM_STATE							171
#define DIMMER_MENU_STATE					172
#define DIMMER_STATE						173
//
// Configuration Sub Menus
#define AUTO_CONFIG_MENU_STATE				180
#define AUTO_CONFIG_STATE					181
#define HIGH_CONTRAST_CONFIG_MENU_STATE		182
#define HIGH_CONTRAST_CONFIG_STATE			183
#define STROBE_CONFIG_MENU_STATE			184
#define STROBE_CONFIG_STATE					185
#define CHASER_CONFIG_MENU_STATE			186
#define CHASER_CONFIG_STATE					187
//
#define RIGHTGAIN_MENU_STATE				188
#define RIGHTGAIN_STATE						189
#define LEFTGAIN_MENU_STATE					190
#define LEFTGAIN_STATE						191
#define MICGAIN_MENU_STATE					192
#define MICGAIN_STATE						193
//
#define INITIAL_STATE 						(CHANNEL_MENU_STATE)
#define END_STATE							250
#define SAME_STATE							251
#define POP_STATE							252
#define IGNORE_STATE						253
//
//*****************************************************************************
// Transitions for the Finite State Machine
#define EMPTY_TRANSITION 		0x00
#define EMPTY_POP_TRANSITION	0x01
#define KEY_TRANSITION 			0x02
#define KEY_PUSH_TRANSITION		0x03
#define VIEW_TRANSITION 		0x04
#define VIEW_PUSH_TRANSITION	0x05
#define EMPTY_POP_TRANSITION_FOLLOWON	0x06
//
#define NULLP 					0
//*****************************************************************************
// The Chaser Op Codes
// the first 6 bits are significant for the opcode the last two bits indicate how much data 00= none 01= 1 byte 10=2 bytes 11=3 bytes
#define NOP					0b0000000000000000		// no operation
#define OUTA		 		0b0000000000000100		// OUTA 		XXXX 		output XX to outputlevel of current channel
#define OUTQA				0b0000000000001000		// OUTQA 		XXXX		output XX to quiescent level of current channel
#define INA					0b0000000000001100		// INA 						move the contents of outputlevel to A
#define INQA				0b0000000000010000		// INQA 					move the contents of quiescent level to A
#define GOTOP				0b0000000000010101		// GOTOP 		XXXX		relative branch instruction (in bytes)
#define LOADK16				0b0000000000011101		// LOADK16		XXXX		load counter with XX (16bits)
#define ATTACKTO			0b0000000000101001		// ATTACKTO		XXXX		attack to 	XX
#define DECAYTO				0b0000000000101101		// DECAYTO		XXXX		decay to 	XX
#define DECNZ				0b0000000000110001		// DECNZ		XXXX		decrement counter and branch if non zero
#define LOADA16				0b0000000000111001		// LOADA16		XXXX		load accumulator	
#define ADDA				0b0000000000111101		// ADDA 		XXXX		add to accumulator
#define ANDA				0b0000000001000001		// ANDA			XXXX		and with accumulator
#define ORA					0b0000000001000101		// ORA			XXXX		or with accumulator
#define	NOTA				0b0000000001001000		// NOTA						1s complement
#define MOVAG1				0b0000000001001100	
#define MOVAG2				0b0000000001010000
#define MOVAG3				0b0000000001010100
#define GETG1A				0b0000000001011000
#define GETG2A				0b0000000001011100
#define GETG3A				0b0000000001100000
#define SAWTOOTHA			0b0000000001100100
#define TRIANGLEA			0b0000000001101000
#define SQUAREA				0b0000000001101100
#define HALT				0b0000000001110000				
#define CALL				0b0000000001110101		// CALL 		XXXX
#define RETURN				0b0000000001111000		// RETURN 
#define XORA				0b0000000001111101		// XORA			XXXX 		xor with accumulator
#define SETCH				0b0000000010000001		// SETCH		XXXX 		set the current channel with literal
#define SETCH1				0b0000000010000100		// SETCH1					set CH1 as current channel
#define SETCH2				0b0000000010001000		// SETCH2					
#define SETCH3				0b0000000010001100		// SETCH3
#define SETCH4				0b0000000010010000		// SETCH4
#define DELAYMS				0b0000000010010101		// WAIT FOR MS 	XXXX		is non blocking and a NOP when in TRIGGERED chaser mode
#define OUTL				0b0000000010011010		// OUTL			XXXXXXXX	output literal output levels to CH1, CH2, CH3, CH4 respectively
#define RANDOML				0b0000000010011100		// RANDOML					outputs random levels to all channels
#define END					0b1111111111111100		// END			not an instruction to mark then end of all chaser programs.
// For Controlling the display
#define MENABLE 			0x0002
#define DENABLE 			0x0001
#define ON_ENABLE 			(DENABLE | MENABLE)
#define BlankScreen()		displayEnable&=~MENABLE;if((displayIndex & 0x1E)!=0x1E)PORTEbits.GBIT=1;
#define UnBlankScreen()		displayEnable|=MENABLE;
//*****************************************************************************
#define	DEFAULT_ATTACK		50
#define DEFAULT_DECAY		50
#define DEFAULT_STROBE		10
#define EQUALIZERS			8
//*****************************************************************************
#define TRIGGER_MINFREQ_DEFAULT		0
#define TRIGGER_MAXFREQ_DEFAULT		500
#define TRIGGER_THRESHOLD_DEFAULT	640
#define TRIGGER_THRESHOLD_LOG2		10
#define TRIGGER_ON					1
#define TRIGGER_OFF					0
#define HEX_LINE_LENGTH_MAX			100
#define HEX_CRC_ERROR				8
#define HEX_EOF						4
#define HEX_ERROR_IN_CODE			2
#define HEX_ERROR					1
#define HEX_OK						0
//*****************************************************************************
#define STATE_STACK_SIZE				8
#define STATE_STACK_OK					0
#define STATE_STACK_UNDERFLOW_ERROR		1
#define STATE_STACK_OVERFLOW_ERROR		2
//*****************************************************************************
#define GAIN_MIN		(0.2*FIXED_DENOMINATOR)
#define GAIN_MAX		(5.0*FIXED_DENOMINATOR)
#define GAIN_DEFAULT	1.0
//*****************************************************************************
//* Typedefs
//*****************************************************************************
typedef struct {
unsigned char stateID;
char *stateTitle;
void (*stateFunction)(int);
unsigned char stateProperty;
unsigned char nextState[NUM_KEY_TRANSITIONS];
} state;								// for each state for Finite State Machine

typedef struct
{
int		*ip;
int		acc;
int		counter;
int		attack;
int		decay;
int		stackp;
int		stack[4];
int 	channel;
int 	currentProgram;
} chaserObject;

typedef struct {
int 	minFreq;
int 	maxFreq;
int		igain;
DOUBLE 	gain;
int		mode;
char 	modeIndex;
long	bin;
int 	counter;
int 	outputChannel[PHASES];
int		outputLevel;
int 	quiescentCurrent;
int		quiescentLevel;
int		attack;
int		decay;
int		strobe;
} channel;					// for each channel

typedef struct {
int period[4];
DOUBLE freq;			// used to calculate real time frequencies of interrupts (in Hz)
DOUBLE duty;			// the duty as a percentage from 0.0 to 100.0
DOUBLE posperiod;		// the positive period between period[2] and period[1] in ms
int	updated;			// =0 if not updated =1 if updated recently
int freqIndex;			// frequencies updates period
} frequencyObject;		// for each frequency channel
//
//
//*****************************************************************************
//
//*****************************************************************************
//
//*****************************************************************************
//
//*****************************************************************************
//
//*****************************************************************************
//

#endif
